//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/scheduler/armscheduler"
	"net/http"
	"net/url"
	"regexp"
)

// JobCollectionsServer is a fake server for instances of the armscheduler.JobCollectionsClient type.
type JobCollectionsServer struct {
	// CreateOrUpdate is the fake for method JobCollectionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, jobCollectionName string, jobCollection armscheduler.JobCollectionDefinition, options *armscheduler.JobCollectionsClientCreateOrUpdateOptions) (resp azfake.Responder[armscheduler.JobCollectionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method JobCollectionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDelete func(ctx context.Context, resourceGroupName string, jobCollectionName string, options *armscheduler.JobCollectionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armscheduler.JobCollectionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisable is the fake for method JobCollectionsClient.BeginDisable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisable func(ctx context.Context, resourceGroupName string, jobCollectionName string, options *armscheduler.JobCollectionsClientBeginDisableOptions) (resp azfake.PollerResponder[armscheduler.JobCollectionsClientDisableResponse], errResp azfake.ErrorResponder)

	// BeginEnable is the fake for method JobCollectionsClient.BeginEnable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnable func(ctx context.Context, resourceGroupName string, jobCollectionName string, options *armscheduler.JobCollectionsClientBeginEnableOptions) (resp azfake.PollerResponder[armscheduler.JobCollectionsClientEnableResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JobCollectionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, jobCollectionName string, options *armscheduler.JobCollectionsClientGetOptions) (resp azfake.Responder[armscheduler.JobCollectionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method JobCollectionsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armscheduler.JobCollectionsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armscheduler.JobCollectionsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method JobCollectionsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armscheduler.JobCollectionsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armscheduler.JobCollectionsClientListBySubscriptionResponse])

	// Patch is the fake for method JobCollectionsClient.Patch
	// HTTP status codes to indicate success: http.StatusOK
	Patch func(ctx context.Context, resourceGroupName string, jobCollectionName string, jobCollection armscheduler.JobCollectionDefinition, options *armscheduler.JobCollectionsClientPatchOptions) (resp azfake.Responder[armscheduler.JobCollectionsClientPatchResponse], errResp azfake.ErrorResponder)
}

// NewJobCollectionsServerTransport creates a new instance of JobCollectionsServerTransport with the provided implementation.
// The returned JobCollectionsServerTransport instance is connected to an instance of armscheduler.JobCollectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJobCollectionsServerTransport(srv *JobCollectionsServer) *JobCollectionsServerTransport {
	return &JobCollectionsServerTransport{
		srv:                         srv,
		beginDelete:                 newTracker[azfake.PollerResponder[armscheduler.JobCollectionsClientDeleteResponse]](),
		beginDisable:                newTracker[azfake.PollerResponder[armscheduler.JobCollectionsClientDisableResponse]](),
		beginEnable:                 newTracker[azfake.PollerResponder[armscheduler.JobCollectionsClientEnableResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armscheduler.JobCollectionsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armscheduler.JobCollectionsClientListBySubscriptionResponse]](),
	}
}

// JobCollectionsServerTransport connects instances of armscheduler.JobCollectionsClient to instances of JobCollectionsServer.
// Don't use this type directly, use NewJobCollectionsServerTransport instead.
type JobCollectionsServerTransport struct {
	srv                         *JobCollectionsServer
	beginDelete                 *tracker[azfake.PollerResponder[armscheduler.JobCollectionsClientDeleteResponse]]
	beginDisable                *tracker[azfake.PollerResponder[armscheduler.JobCollectionsClientDisableResponse]]
	beginEnable                 *tracker[azfake.PollerResponder[armscheduler.JobCollectionsClientEnableResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armscheduler.JobCollectionsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armscheduler.JobCollectionsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for JobCollectionsServerTransport.
func (j *JobCollectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JobCollectionsClient.CreateOrUpdate":
		resp, err = j.dispatchCreateOrUpdate(req)
	case "JobCollectionsClient.BeginDelete":
		resp, err = j.dispatchBeginDelete(req)
	case "JobCollectionsClient.BeginDisable":
		resp, err = j.dispatchBeginDisable(req)
	case "JobCollectionsClient.BeginEnable":
		resp, err = j.dispatchBeginEnable(req)
	case "JobCollectionsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JobCollectionsClient.NewListByResourceGroupPager":
		resp, err = j.dispatchNewListByResourceGroupPager(req)
	case "JobCollectionsClient.NewListBySubscriptionPager":
		resp, err = j.dispatchNewListBySubscriptionPager(req)
	case "JobCollectionsClient.Patch":
		resp, err = j.dispatchPatch(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armscheduler.JobCollectionDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, jobCollectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobCollectionDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if j.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := j.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginDelete(req.Context(), resourceGroupNameParam, jobCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		j.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		j.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		j.beginDelete.remove(req)
	}

	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchBeginDisable(req *http.Request) (*http.Response, error) {
	if j.srv.BeginDisable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisable not implemented")}
	}
	beginDisable := j.beginDisable.get(req)
	if beginDisable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginDisable(req.Context(), resourceGroupNameParam, jobCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisable = &respr
		j.beginDisable.add(req, beginDisable)
	}

	resp, err := server.PollerResponderNext(beginDisable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		j.beginDisable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisable) {
		j.beginDisable.remove(req)
	}

	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchBeginEnable(req *http.Request) (*http.Response, error) {
	if j.srv.BeginEnable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnable not implemented")}
	}
	beginEnable := j.beginEnable.get(req)
	if beginEnable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enable`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginEnable(req.Context(), resourceGroupNameParam, jobCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnable = &respr
		j.beginEnable.add(req, beginEnable)
	}

	resp, err := server.PollerResponderNext(beginEnable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		j.beginEnable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnable) {
		j.beginEnable.remove(req)
	}

	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), resourceGroupNameParam, jobCollectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobCollectionDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := j.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		j.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armscheduler.JobCollectionsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		j.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := j.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := j.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		j.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armscheduler.JobCollectionsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		j.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (j *JobCollectionsServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if j.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Scheduler/jobCollections/(?P<jobCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armscheduler.JobCollectionDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Patch(req.Context(), resourceGroupNameParam, jobCollectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobCollectionDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
