//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagesync/armstoragesync"
	"net/http"
	"net/url"
	"regexp"
)

// MicrosoftStorageSyncServer is a fake server for instances of the armstoragesync.MicrosoftStorageSyncClient type.
type MicrosoftStorageSyncServer struct {
	// LocationOperationStatus is the fake for method MicrosoftStorageSyncClient.LocationOperationStatus
	// HTTP status codes to indicate success: http.StatusOK
	LocationOperationStatus func(ctx context.Context, locationName string, operationID string, options *armstoragesync.MicrosoftStorageSyncClientLocationOperationStatusOptions) (resp azfake.Responder[armstoragesync.MicrosoftStorageSyncClientLocationOperationStatusResponse], errResp azfake.ErrorResponder)
}

// NewMicrosoftStorageSyncServerTransport creates a new instance of MicrosoftStorageSyncServerTransport with the provided implementation.
// The returned MicrosoftStorageSyncServerTransport instance is connected to an instance of armstoragesync.MicrosoftStorageSyncClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMicrosoftStorageSyncServerTransport(srv *MicrosoftStorageSyncServer) *MicrosoftStorageSyncServerTransport {
	return &MicrosoftStorageSyncServerTransport{srv: srv}
}

// MicrosoftStorageSyncServerTransport connects instances of armstoragesync.MicrosoftStorageSyncClient to instances of MicrosoftStorageSyncServer.
// Don't use this type directly, use NewMicrosoftStorageSyncServerTransport instead.
type MicrosoftStorageSyncServerTransport struct {
	srv *MicrosoftStorageSyncServer
}

// Do implements the policy.Transporter interface for MicrosoftStorageSyncServerTransport.
func (m *MicrosoftStorageSyncServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MicrosoftStorageSyncClient.LocationOperationStatus":
		resp, err = m.dispatchLocationOperationStatus(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MicrosoftStorageSyncServerTransport) dispatchLocationOperationStatus(req *http.Request) (*http.Response, error) {
	if m.srv.LocationOperationStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method LocationOperationStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.LocationOperationStatus(req.Context(), locationNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LocationOperationStatus, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSCorrelationRequestID; val != nil {
		resp.Header.Set("x-ms-correlation-request-id", *val)
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}
