// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package optimization aliases all exported identifiers in package
// "cloud.google.com/go/optimization/apiv1/optimizationpb".
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package optimization

import (
	src "cloud.google.com/go/optimization/apiv1/optimizationpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/optimization/apiv1/optimizationpb
const (
	AsyncModelMetadata_CANCELLED                                                                              = src.AsyncModelMetadata_CANCELLED
	AsyncModelMetadata_FAILED                                                                                 = src.AsyncModelMetadata_FAILED
	AsyncModelMetadata_RUNNING                                                                                = src.AsyncModelMetadata_RUNNING
	AsyncModelMetadata_STATE_UNSPECIFIED                                                                      = src.AsyncModelMetadata_STATE_UNSPECIFIED
	AsyncModelMetadata_SUCCEEDED                                                                              = src.AsyncModelMetadata_SUCCEEDED
	DataFormat_DATA_FORMAT_UNSPECIFIED                                                                        = src.DataFormat_DATA_FORMAT_UNSPECIFIED
	DataFormat_JSON                                                                                           = src.DataFormat_JSON
	DataFormat_STRING                                                                                         = src.DataFormat_STRING
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_LEVEL_UNSPECIFIED                              = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_LEVEL_UNSPECIFIED
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_ALL_AFTER_THRESHOLD                      = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_ALL_AFTER_THRESHOLD
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AFTER_THRESHOLD              = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AFTER_THRESHOLD
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD
	OptimizeToursRequest_CONSUME_ALL_AVAILABLE_TIME                                                           = src.OptimizeToursRequest_CONSUME_ALL_AVAILABLE_TIME
	OptimizeToursRequest_DEFAULT_SOLVE                                                                        = src.OptimizeToursRequest_DEFAULT_SOLVE
	OptimizeToursRequest_DETECT_SOME_INFEASIBLE_SHIPMENTS                                                     = src.OptimizeToursRequest_DETECT_SOME_INFEASIBLE_SHIPMENTS
	OptimizeToursRequest_RETURN_FAST                                                                          = src.OptimizeToursRequest_RETURN_FAST
	OptimizeToursRequest_SEARCH_MODE_UNSPECIFIED                                                              = src.OptimizeToursRequest_SEARCH_MODE_UNSPECIFIED
	OptimizeToursRequest_VALIDATE_ONLY                                                                        = src.OptimizeToursRequest_VALIDATE_ONLY
	ShipmentTypeIncompatibility_INCOMPATIBILITY_MODE_UNSPECIFIED                                              = src.ShipmentTypeIncompatibility_INCOMPATIBILITY_MODE_UNSPECIFIED
	ShipmentTypeIncompatibility_NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY                                            = src.ShipmentTypeIncompatibility_NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY
	ShipmentTypeIncompatibility_NOT_PERFORMED_BY_SAME_VEHICLE                                                 = src.ShipmentTypeIncompatibility_NOT_PERFORMED_BY_SAME_VEHICLE
	ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_DELIVERY_TIME                                                  = src.ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_DELIVERY_TIME
	ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_PICKUP_TIME                                                    = src.ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_PICKUP_TIME
	ShipmentTypeRequirement_PERFORMED_BY_SAME_VEHICLE                                                         = src.ShipmentTypeRequirement_PERFORMED_BY_SAME_VEHICLE
	ShipmentTypeRequirement_REQUIREMENT_MODE_UNSPECIFIED                                                      = src.ShipmentTypeRequirement_REQUIREMENT_MODE_UNSPECIFIED
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT                                  = src.SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT                                  = src.SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS                                    = src.SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT                           = src.SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT
	SkippedShipment_Reason_CODE_UNSPECIFIED                                                                   = src.SkippedShipment_Reason_CODE_UNSPECIFIED
	SkippedShipment_Reason_DEMAND_EXCEEDS_VEHICLE_CAPACITY                                                    = src.SkippedShipment_Reason_DEMAND_EXCEEDS_VEHICLE_CAPACITY
	SkippedShipment_Reason_NO_VEHICLE                                                                         = src.SkippedShipment_Reason_NO_VEHICLE
	SkippedShipment_Reason_VEHICLE_NOT_ALLOWED                                                                = src.SkippedShipment_Reason_VEHICLE_NOT_ALLOWED
	Vehicle_DRIVING                                                                                           = src.Vehicle_DRIVING
	Vehicle_FIRST_IN_FIRST_OUT                                                                                = src.Vehicle_FIRST_IN_FIRST_OUT
	Vehicle_LAST_IN_FIRST_OUT                                                                                 = src.Vehicle_LAST_IN_FIRST_OUT
	Vehicle_TRAVEL_MODE_UNSPECIFIED                                                                           = src.Vehicle_TRAVEL_MODE_UNSPECIFIED
	Vehicle_UNLOADING_POLICY_UNSPECIFIED                                                                      = src.Vehicle_UNLOADING_POLICY_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/optimization/apiv1/optimizationpb
var (
	AsyncModelMetadata_State_name                                          = src.AsyncModelMetadata_State_name
	AsyncModelMetadata_State_value                                         = src.AsyncModelMetadata_State_value
	DataFormat_name                                                        = src.DataFormat_name
	DataFormat_value                                                       = src.DataFormat_value
	File_google_cloud_optimization_v1_async_model_proto                    = src.File_google_cloud_optimization_v1_async_model_proto
	File_google_cloud_optimization_v1_fleet_routing_proto                  = src.File_google_cloud_optimization_v1_fleet_routing_proto
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_name  = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_name
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_value = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_value
	OptimizeToursRequest_SearchMode_name                                   = src.OptimizeToursRequest_SearchMode_name
	OptimizeToursRequest_SearchMode_value                                  = src.OptimizeToursRequest_SearchMode_value
	OptimizeToursRequest_SolvingMode_name                                  = src.OptimizeToursRequest_SolvingMode_name
	OptimizeToursRequest_SolvingMode_value                                 = src.OptimizeToursRequest_SolvingMode_value
	ShipmentTypeIncompatibility_IncompatibilityMode_name                   = src.ShipmentTypeIncompatibility_IncompatibilityMode_name
	ShipmentTypeIncompatibility_IncompatibilityMode_value                  = src.ShipmentTypeIncompatibility_IncompatibilityMode_value
	ShipmentTypeRequirement_RequirementMode_name                           = src.ShipmentTypeRequirement_RequirementMode_name
	ShipmentTypeRequirement_RequirementMode_value                          = src.ShipmentTypeRequirement_RequirementMode_value
	SkippedShipment_Reason_Code_name                                       = src.SkippedShipment_Reason_Code_name
	SkippedShipment_Reason_Code_value                                      = src.SkippedShipment_Reason_Code_value
	Vehicle_TravelMode_name                                                = src.Vehicle_TravelMode_name
	Vehicle_TravelMode_value                                               = src.Vehicle_TravelMode_value
	Vehicle_UnloadingPolicy_name                                           = src.Vehicle_UnloadingPolicy_name
	Vehicle_UnloadingPolicy_value                                          = src.Vehicle_UnloadingPolicy_value
)

// Aggregated metrics for
// [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute] (resp. for
// [OptimizeToursResponse][google.cloud.optimization.v1.OptimizeToursResponse]
// over all [Transition][google.cloud.optimization.v1.ShipmentRoute.Transition]
// and/or [Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] (resp. over
// all [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute]) elements.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type AggregatedMetrics = src.AggregatedMetrics

// The long running operation metadata for async model related methods.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type AsyncModelMetadata = src.AsyncModelMetadata

// Possible states of the operation.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type AsyncModelMetadata_State = src.AsyncModelMetadata_State

// Request to batch optimize tours as an asynchronous operation. Each input
// file should contain one `OptimizeToursRequest`, and each output file will
// contain one `OptimizeToursResponse`. The request contains information to
// read/write and parse the files. All the input and output files should be
// under the same project.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BatchOptimizeToursRequest = src.BatchOptimizeToursRequest

// Information for solving one optimization model asynchronously.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BatchOptimizeToursRequest_AsyncModelConfig = src.BatchOptimizeToursRequest_AsyncModelConfig

// Response to a `BatchOptimizeToursRequest`. This is returned in the LRO
// Operation after the operation is complete.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BatchOptimizeToursResponse = src.BatchOptimizeToursResponse

// Rules to generate time breaks for a vehicle (e.g. lunch breaks). A break is
// a contiguous period of time during which the vehicle remains idle at its
// current position and cannot perform any visit. A break may occur: - during
// the travel between two visits (which includes the time right before or right
// after a visit, but not in the middle of a visit), in which case it extends
// the corresponding transit time between the visits, - or before the vehicle
// start (the vehicle may not start in the middle of a break), in which case it
// does not affect the vehicle start time. - or after the vehicle end (ditto,
// with the vehicle end time).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BreakRule = src.BreakRule

// The sequence of breaks (i.e. their number and order) that apply to each
// vehicle must be known beforehand. The repeated `BreakRequest`s define that
// sequence, in the order in which they must occur. Their time windows
// (`earliest_start_time` / `latest_start_time`) may overlap, but they must be
// compatible with the order (this is checked).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BreakRule_BreakRequest = src.BreakRule_BreakRequest

// One may further constrain the frequency and duration of the breaks
// specified above, by enforcing a minimum break frequency, such as "There must
// be a break of at least 1 hour every 12 hours". Assuming that this can be
// interpreted as "Within any sliding time window of 12h, there must be at
// least one break of at least one hour", that example would translate to the
// following `FrequencyConstraint`: ``` { min_break_duration { seconds: 3600 }
// # 1 hour. max_inter_break_duration { seconds: 39600 } # 11 hours (12 - 1 =
// 11). } ``` The timing and duration of the breaks in the solution will
// respect all such constraints, in addition to the time windows and minimum
// durations already specified in the `BreakRequest`. A `FrequencyConstraint`
// may in practice apply to non-consecutive breaks. For example, the following
// schedule honors the "1h every 12h" example: ``` 04:00 vehicle start ..
// performing travel and visits .. 09:00 1 hour break 10:00 end of the break ..
// performing travel and visits .. 12:00 20-min lunch break 12:20 end of the
// break .. performing travel and visits .. 21:00 1 hour break 22:00 end of the
// break .. performing travel and visits .. 23:59 vehicle end ```
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type BreakRule_FrequencyConstraint = src.BreakRule_FrequencyConstraint

// Deprecated: Use [Shipment.Load][], [Vehicle.LoadLimit][] and
// [ShipmentRoute.VehicleLoad][] instead. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type CapacityQuantity = src.CapacityQuantity

// Deprecated: Use [Vehicle.LoadLimit.Interval][] instead. Deprecated: Do not
// use.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type CapacityQuantityInterval = src.CapacityQuantityInterval

// Data formats for input and output files.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type DataFormat = src.DataFormat

// A limit defining a maximum distance which can be traveled. It can be either
// hard or soft. If a soft limit is defined, both `soft_max_meters` and
// `cost_per_kilometer_above_soft_max` must be defined and be nonnegative.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type DistanceLimit = src.DistanceLimit

// FleetRoutingClient is the client API for FleetRouting service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type FleetRoutingClient = src.FleetRoutingClient

// FleetRoutingServer is the server API for FleetRouting service.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type FleetRoutingServer = src.FleetRoutingServer

// The Google Cloud Storage location where the output file will be written to.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type GcsDestination = src.GcsDestination

// The Google Cloud Storage location where the input file will be read from.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type GcsSource = src.GcsSource

// Solution injected in the request including information about which visits
// must be constrained and how they must be constrained.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type InjectedSolutionConstraint = src.InjectedSolutionConstraint

// For a group of vehicles, specifies at what threshold(s) constraints on
// visits will be relaxed and to which level. Shipments listed in the
// `skipped_shipment` field are constrained to be skipped; i.e., they cannot be
// performed.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type InjectedSolutionConstraint_ConstraintRelaxation = src.InjectedSolutionConstraint_ConstraintRelaxation

// If `relaxations` is empty, the start time and sequence of all visits on
// `routes` are fully constrained and no new visits may be inserted or added to
// those routes. Also, a vehicle's start and end time in `routes` is fully
// constrained, unless the vehicle is empty (i.e., has no visits and has
// `used_if_route_is_empty` set to false in the model). `relaxations(i).level`
// specifies the constraint relaxation level applied to a visit #j that
// satisfies: - `route.visits(j).start_time >= relaxations(i).threshold_time`
// AND - `j + 1 >= relaxations(i).threshold_visit_count` Similarly, the vehicle
// start is relaxed to `relaxations(i).level` if it satisfies: -
// `vehicle_start_time >= relaxations(i).threshold_time` AND -
// `relaxations(i).threshold_visit_count == 0` and the vehicle end is relaxed
// to `relaxations(i).level` if it satisfies: - `vehicle_end_time >=
// relaxations(i).threshold_time` AND - `route.visits_size() + 1 >=
// relaxations(i).threshold_visit_count` To apply a relaxation level if a visit
// meets the `threshold_visit_count` OR the `threshold_time` add two
// `relaxations` with the same `level`: one with only `threshold_visit_count`
// set and the other with only `threshold_time` set. If a visit satisfies the
// conditions of multiple `relaxations`, the most relaxed level applies. As a
// result, from the vehicle start through the route visits in order to the
// vehicle end, the relaxation level becomes more relaxed: i.e., the relaxation
// level is non-decreasing as the route progresses. The timing and sequence of
// route visits that do not satisfy the threshold conditions of any
// `relaxations` are fully constrained and no visits may be inserted into these
// sequences. Also, if a vehicle start or end does not satisfy the conditions
// of any relaxation the time is fixed, unless the vehicle is empty.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type InjectedSolutionConstraint_ConstraintRelaxation_Relaxation = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation

// Expresses the different constraint relaxation levels, which are applied for
// a visit and those that follow when it satifies the threshold conditions. The
// enumeration below is in order of increasing relaxation.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level = src.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level

// The desired input location information.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type InputConfig = src.InputConfig
type InputConfig_GcsSource = src.InputConfig_GcsSource

// Encapsulates a location (a geographic point, and an optional heading).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Location = src.Location

// Request to be given to a tour optimization solver which defines the
// shipment model to solve as well as optimization parameters.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursRequest = src.OptimizeToursRequest

// Mode defining the behavior of the search, trading off latency versus
// solution quality. In all modes, the global request deadline is enforced.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursRequest_SearchMode = src.OptimizeToursRequest_SearchMode

// Defines how the solver should handle the request. In all modes but
// `VALIDATE_ONLY`, if the request is invalid, you will receive an
// `INVALID_REQUEST` error. See
// [max_validation_errors][google.cloud.optimization.v1.OptimizeToursRequest.max_validation_errors]
// to cap the number of errors returned.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursRequest_SolvingMode = src.OptimizeToursRequest_SolvingMode

// Response after solving a tour optimization problem containing the routes
// followed by each vehicle, the shipments which have been skipped and the
// overall cost of the solution.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursResponse = src.OptimizeToursResponse

// Overall metrics, aggregated over all routes.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursResponse_Metrics = src.OptimizeToursResponse_Metrics

// Describes an error encountered when validating an `OptimizeToursRequest`.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursValidationError = src.OptimizeToursValidationError

// Specifies a context for the validation error. A `FieldReference` always
// refers to a given field in this file and follows the same hierarchical
// structure. For example, we may specify element #2 of `start_time_windows` of
// vehicle #5 using: ``` name: "vehicles" index: 5 sub_field { name:
// "end_time_windows" index: 2 } ``` We however omit top-level entities such as
// `OptimizeToursRequest` or `ShipmentModel` to avoid crowding the message.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OptimizeToursValidationError_FieldReference = src.OptimizeToursValidationError_FieldReference
type OptimizeToursValidationError_FieldReference_Index = src.OptimizeToursValidationError_FieldReference_Index
type OptimizeToursValidationError_FieldReference_Key = src.OptimizeToursValidationError_FieldReference_Key

// The desired output location.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type OutputConfig = src.OutputConfig
type OutputConfig_GcsDestination = src.OutputConfig_GcsDestination

// The shipment of a single item, from one of its pickups to one of its
// deliveries. For the shipment to be considered as performed, a unique vehicle
// must visit one of its pickup locations (and decrease its spare capacities
// accordingly), then visit one of its delivery locations later on (and
// therefore re-increase its spare capacities accordingly).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Shipment = src.Shipment

// A shipment model contains a set of shipments which must be performed by a
// set of vehicles, while minimizing the overall cost, which is the sum of: -
// the cost of routing the vehicles (sum of cost per total time, cost per
// travel time, and fixed cost over all vehicles). - the unperformed shipment
// penalties. - the cost of the global duration of the shipments
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel = src.ShipmentModel

// Deprecated: Use top level [BreakRule][] instead. Rules to generate time
// breaks for a vehicle (e.g. lunch breaks). A break is a contiguous period of
// time during which the vehicle remains idle at its current position and
// cannot perform any visit. A break may occur: - during the travel between two
// visits (which includes the time right before or right after a visit, but not
// in the middle of a visit), in which case it extends the corresponding
// transit time between the visits, - or before the vehicle start (the vehicle
// may not start in the middle of a break), in which case it does not affect
// the vehicle start time. - or after the vehicle end (ditto, with the vehicle
// end time). Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_BreakRule = src.ShipmentModel_BreakRule

// The sequence of breaks (i.e. their number and order) that apply to each
// vehicle must be known beforehand. The repeated `BreakRequest`s define that
// sequence, in the order in which they must occur. Their time windows
// (`earliest_start_time` / `latest_start_time`) may overlap, but they must be
// compatible with the order (this is checked).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_BreakRule_BreakRequest = src.ShipmentModel_BreakRule_BreakRequest

// One may further constrain the frequency and duration of the breaks
// specified above, by enforcing a minimum break frequency, such as "There must
// be a break of at least 1 hour every 12 hours". Assuming that this can be
// interpreted as "Within any sliding time window of 12h, there must be at
// least one break of at least one hour", that example would translate to the
// following `FrequencyConstraint`: ``` { min_break_duration { seconds: 3600 }
// # 1 hour. max_inter_break_duration { seconds: 39600 } # 11 hours (12 - 1 =
// 11). } ``` The timing and duration of the breaks in the solution will
// respect all such constraints, in addition to the time windows and minimum
// durations already specified in the `BreakRequest`. A `FrequencyConstraint`
// may in practice apply to non-consecutive breaks. For example, the following
// schedule honors the "1h every 12h" example: ``` 04:00 vehicle start ..
// performing travel and visits .. 09:00 1 hour break 10:00 end of the break ..
// performing travel and visits .. 12:00 20-min lunch break 12:20 end of the
// break .. performing travel and visits .. 21:00 1 hour break 22:00 end of the
// break .. performing travel and visits .. 23:59 vehicle end ```
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_BreakRule_FrequencyConstraint = src.ShipmentModel_BreakRule_FrequencyConstraint

// Specifies a duration and distance matrix from visit and vehicle start
// locations to visit and vehicle end locations.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_DurationDistanceMatrix = src.ShipmentModel_DurationDistanceMatrix

// Specifies a row of the duration and distance matrix.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_DurationDistanceMatrix_Row = src.ShipmentModel_DurationDistanceMatrix_Row

// A precedence rule between two events (each event is the pickup or the
// delivery of a shipment): the "second" event has to start at least
// `offset_duration` after "first" has started. Several precedences can refer
// to the same (or related) events, e.g., "pickup of B happens after delivery
// of A" and "pickup of C happens after pickup of B". Furthermore, precedences
// only apply when both shipments are performed and are otherwise ignored.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentModel_PrecedenceRule = src.ShipmentModel_PrecedenceRule

// A vehicle's route can be decomposed, along the time axis, like this (we
// assume there are n visits): ``` | | | | | T[2], | | | | Transition | Visit
// #0 | | | V[2], | | | | #0 | aka | T[1] | V[1] | ... | V[n-1] | T[n] | | aka
// T[0] | V[0] | | | V[n-2],| | | | | | | | T[n-1] | | | ^ ^ ^ ^ ^ ^ ^ ^
// vehicle V[0].start V[0].end V[1]. V[1]. V[n]. V[n]. vehicle start (arrival)
// (departure) start end start end end ``` Note that we make a difference
// between: - "punctual events", such as the vehicle start and end and each
// visit's start and end (aka arrival and departure). They happen at a given
// second. - "time intervals", such as the visits themselves, and the
// transition between visits. Though time intervals can sometimes have zero
// duration, i.e. start and end at the same second, they often have a positive
// duration. Invariants: - If there are n visits, there are n+1 transitions. -
// A visit is always surrounded by a transition before it (same index) and a
// transition after it (index + 1). - The vehicle start is always followed by
// transition #0. - The vehicle end is always preceded by transition #n.
// Zooming in, here is what happens during a `Transition` and a `Visit`: ```
// ---+-------------------------------------+-----------------------------+-->
// | TRANSITION[i] | VISIT[i] | | | | | * TRAVEL: the vehicle moves from |
// PERFORM the visit: | | VISIT[i-1].departure_location to | | |
// VISIT[i].arrival_location, which | * Spend some time: | | takes a given
// travel duration | the "visit duration". | | and distance | | | | * Load or
// unload | | * BREAKS: the driver may have | some quantities from the | |
// breaks (e.g. lunch break). | vehicle: the "demand". | | | | | * WAIT: the
// driver/vehicle does | | | nothing. This can happen for | | | many reasons,
// for example when | | | the vehicle reaches the next | | | event's
// destination before the | | | start of its time window | | | | | | * DELAY:
// *right before* the next | | | arrival. E.g. the vehicle and/or | | | driver
// spends time unloading. | | | | |
// ---+-------------------------------------+-----------------------------+-->
// ^ ^ ^ V[i-1].end V[i].start V[i].end ``` Lastly, here is how the TRAVEL,
// BREAKS, DELAY and WAIT can be arranged during a transition. - They don't
// overlap. - The DELAY is unique and *must* be a contiguous period of time
// right before the next visit (or vehicle end). Thus, it suffice to know the
// delay duration to know its start and end time. - The BREAKS are contiguous,
// non-overlapping periods of time. The response specifies the start time and
// duration of each break. - TRAVEL and WAIT are "preemptable": they can be
// interrupted several times during this transition. Clients can assume that
// travel happens "as soon as possible" and that "wait" fills the remaining
// time. A (complex) example: ``` TRANSITION[i]
// --++-----+-----------------------------------------------------------++-->
// || | | | | | | || || T | B | T | | B | | D || || r | r | r | W | r | W | e
// || || a | e | a | a | e | a | l || || v | a | v | i | a | i | a || || e | k
// | e | t | k | t | y || || l | | l | | | | || || | | | | | | ||
// --++-----------------------------------------------------------------++-->
// ```
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute = src.ShipmentRoute

// Data representing the execution of a break.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_Break = src.ShipmentRoute_Break

// Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead. Time
// interval spent on the route resulting from a
// [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_Delay = src.ShipmentRoute_Delay

// The encoded representation of a polyline. More information on polyline
// encoding can be found here:
// https://developers.google.com/maps/documentation/utilities/polylinealgorithm
// https://developers.google.com/maps/documentation/javascript/reference/geometry#encoding.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_EncodedPolyline = src.ShipmentRoute_EncodedPolyline

// Transition between two events on the route. See the description of
// [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute]. If the vehicle
// does not have a `start_location` and/or `end_location`, the corresponding
// travel metrics are 0.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_Transition = src.ShipmentRoute_Transition

// Deprecated: Use [ShipmentRoute.transitions][] instead. Travel between each
// visit, along the route: from the vehicle's `start_location` to the first
// visit's `arrival_location`, then from the first visit's `departure_location`
// to the second visit's `arrival_location`, and so on until the vehicle's
// `end_location`. This accounts only for the actual travel between visits, not
// counting the waiting time, the time spent performing a visit, nor the
// distance covered during a visit. Invariant: `travel_steps_size() ==
// visits_size() + 1`. If the vehicle does not have a start_ and/or
// end_location, the corresponding travel metrics are 0 and/or empty.
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_TravelStep = src.ShipmentRoute_TravelStep

// Reports the actual load of the vehicle at some point along the route, for a
// given type (see
// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_VehicleLoad = src.ShipmentRoute_VehicleLoad

// A visit performed during a route. This visit corresponds to a pickup or a
// delivery of a `Shipment`.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentRoute_Visit = src.ShipmentRoute_Visit

// Specifies incompatibilties between shipments depending on their
// shipment_type. The appearance of incompatible shipments on the same route is
// restricted based on the incompatibility mode.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentTypeIncompatibility = src.ShipmentTypeIncompatibility

// Modes defining how the appearance of incompatible shipments are restricted
// on the same route.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentTypeIncompatibility_IncompatibilityMode = src.ShipmentTypeIncompatibility_IncompatibilityMode

// Specifies requirements between shipments based on their shipment_type. The
// specifics of the requirement are defined by the requirement mode.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentTypeRequirement = src.ShipmentTypeRequirement

// Modes defining the appearance of dependent shipments on a route.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type ShipmentTypeRequirement_RequirementMode = src.ShipmentTypeRequirement_RequirementMode

// When performing a visit, a predefined amount may be added to the vehicle
// load if it's a pickup, or subtracted if it's a delivery. This message
// defines such amount. See
// [load_demands][google.cloud.optimization.v1.Shipment.load_demands].
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Shipment_Load = src.Shipment_Load

// Request for a visit which can be done by a vehicle: it has a geo-location
// (or two, see below), opening and closing times represented by time windows,
// and a service duration time (time spent by the vehicle once it has arrived
// to pickup or drop off goods).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Shipment_VisitRequest = src.Shipment_VisitRequest

// Specifies details of unperformed shipments in a solution. For trivial cases
// and/or if we are able to identify the cause for skipping, we report the
// reason here.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type SkippedShipment = src.SkippedShipment

// If we can explain why the shipment was skipped, reasons will be listed
// here. If the reason is not the same for all vehicles, `reason` will have
// more than 1 element. A skipped shipment cannot have duplicate reasons, i.e.
// where all fields are the same except for `example_vehicle_index`. Example:
// ``` reasons { code: DEMAND_EXCEEDS_VEHICLE_CAPACITY example_vehicle_index: 1
// example_exceeded_capacity_type: "Apples" } reasons { code:
// DEMAND_EXCEEDS_VEHICLE_CAPACITY example_vehicle_index: 3
// example_exceeded_capacity_type: "Pears" } reasons { code:
// CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT example_vehicle_index: 1 }
// ``` The skipped shipment is incompatible with all vehicles. The reasons may
// be different for all vehicles but at least one vehicle's "Apples" capacity
// would be exceeded (including vehicle 1), at least one vehicle's "Pears"
// capacity would be exceeded (including vehicle 3) and at least one vehicle's
// distance limit would be exceeded (including vehicle 1).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type SkippedShipment_Reason = src.SkippedShipment_Reason

// Code identifying the reason type. The order here is meaningless. In
// particular, it gives no indication of whether a given reason will appear
// before another in the solution, if both apply.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type SkippedShipment_Reason_Code = src.SkippedShipment_Reason_Code

// Time windows constrain the time of an event, such as the arrival time at a
// visit, or the start and end time of a vehicle. Hard time window bounds,
// `start_time` and `end_time`, enforce the earliest and latest time of the
// event, such that `start_time <= event_time <= end_time`. The soft time
// window lower bound, `soft_start_time`, expresses a preference for the event
// to happen at or after `soft_start_time` by incurring a cost proportional to
// how long before soft_start_time the event occurs. The soft time window upper
// bound, `soft_end_time`, expresses a preference for the event to happen at or
// before `soft_end_time` by incurring a cost proportional to how long after
// `soft_end_time` the event occurs. `start_time`, `end_time`,
// `soft_start_time` and `soft_end_time` should be within the global time
// limits (see
// [ShipmentModel.global_start_time][google.cloud.optimization.v1.ShipmentModel.global_start_time]
// and
// [ShipmentModel.global_end_time][google.cloud.optimization.v1.ShipmentModel.global_end_time])
// and should respect: ``` 0 <= `start_time` <= `soft_start_time` <= `end_time`
// and 0 <= `start_time` <= `soft_end_time` <= `end_time`. ```
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type TimeWindow = src.TimeWindow

// Specifies attributes of transitions between two consecutive visits on a
// route. Several `TransitionAttributes` may apply to the same transition: in
// that case, all extra costs add up and the strictest constraint or limit
// applies (following natural "AND" semantics).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type TransitionAttributes = src.TransitionAttributes

// UnimplementedFleetRoutingServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type UnimplementedFleetRoutingServer = src.UnimplementedFleetRoutingServer

// Models a vehicle in a shipment problem. Solving a shipment problem will
// build a route starting from `start_location` and ending at `end_location`
// for this vehicle. A route is a sequence of visits (see `ShipmentRoute`).
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle = src.Vehicle

// A limit defining a maximum duration of the route of a vehicle. It can be
// either hard or soft. When a soft limit field is defined, both the soft max
// threshold and its associated cost must be defined together.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle_DurationLimit = src.Vehicle_DurationLimit

// Defines a load limit applying to a vehicle, e.g. "this truck may only carry
// up to 3500 kg". See
// [load_limits][google.cloud.optimization.v1.Vehicle.load_limits].
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle_LoadLimit = src.Vehicle_LoadLimit

// Interval of acceptable load amounts.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle_LoadLimit_Interval = src.Vehicle_LoadLimit_Interval

// Travel modes which can be used by vehicles. These should be a subset of the
// Google Maps Platform Routes Preferred API travel modes, see:
// https://developers.google.com/maps/documentation/routes_preferred/reference/rest/Shared.Types/RouteTravelMode.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle_TravelMode = src.Vehicle_TravelMode

// Policy on how a vehicle can be unloaded. Applies only to shipments having
// both a pickup and a delivery. Other shipments are free to occur anywhere on
// the route independent of `unloading_policy`.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Vehicle_UnloadingPolicy = src.Vehicle_UnloadingPolicy

// Encapsulates a waypoint. Waypoints mark arrival and departure locations of
// VisitRequests, and start and end locations of Vehicles.
//
// Deprecated: Please use types in: cloud.google.com/go/optimization/apiv1/optimizationpb
type Waypoint = src.Waypoint
type Waypoint_Location = src.Waypoint_Location
type Waypoint_PlaceId = src.Waypoint_PlaceId

// Deprecated: Please use funcs in: cloud.google.com/go/optimization/apiv1/optimizationpb
func NewFleetRoutingClient(cc grpc.ClientConnInterface) FleetRoutingClient {
	return src.NewFleetRoutingClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/optimization/apiv1/optimizationpb
func RegisterFleetRoutingServer(s *grpc.Server, srv FleetRoutingServer) {
	src.RegisterFleetRoutingServer(s, srv)
}
