/**************************************************************************
 **                                                                      **
 ** Copyright (C) 2011-2026 Lukas Spies                                  **
 ** Contact: https://photoqt.org                                         **
 **                                                                      **
 ** This file is part of PhotoQt.                                        **
 **                                                                      **
 ** PhotoQt is free software: you can redistribute it and/or modify      **
 ** it under the terms of the GNU General Public License as published by **
 ** the Free Software Foundation, either version 2 of the License, or    **
 ** (at your option) any later version.                                  **
 **                                                                      **
 ** PhotoQt is distributed in the hope that it will be useful,           **
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
 ** GNU General Public License for more details.                         **
 **                                                                      **
 ** You should have received a copy of the GNU General Public License    **
 ** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
 **                                                                      **
 **************************************************************************/

import QtQuick
import PhotoQt

PQToolTip {

    id: ttip

    Connections {

        target: PQCNotify

        function onShowToolTip(txt : string, pos : point) {
            ttip.showToolTip(txt, pos)
        }

        function onHideToolTip(txt : string) {
            if(ttip.text === txt)
                ttip.hide()
        }

    }

    function showToolTip(txt : string, pos : point) {
        ttip.hide()
        pos = ttip.parent.mapFromGlobal(pos)
        ttip.x = Qt.binding(function() { return pos.x })
        ttip.y = Qt.binding(function() { return pos.y-ttip.height })
        ttip.show(txt, 5000)
    }

}
