# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtSolutionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solutions_get(self, resource_group):
        response = self.client.solutions.get(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solutions_begin_create_or_update(self, resource_group):
        response = self.client.solutions.begin_create_or_update(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            resource={
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "availableSolutionTemplateVersions": [
                        {"isConfigured": bool, "latestConfigRevision": "str", "solutionTemplateVersion": "str"}
                    ],
                    "provisioningState": "str",
                    "solutionTemplateId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solutions_begin_update(self, resource_group):
        response = self.client.solutions.begin_update(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            properties={
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "availableSolutionTemplateVersions": [
                        {"isConfigured": bool, "latestConfigRevision": "str", "solutionTemplateVersion": "str"}
                    ],
                    "provisioningState": "str",
                    "solutionTemplateId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solutions_begin_delete(self, resource_group):
        response = self.client.solutions.begin_delete(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solutions_list_by_target(self, resource_group):
        response = self.client.solutions.list_by_target(
            resource_group_name=resource_group.name,
            target_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
