// This file contains generated code. Do not edit directly.
// To regenerate this, run 'make'.

//! Bindings to the `Shm` X11 extension.

#![allow(clippy::too_many_arguments)]
// The code generator is simpler if it can always use conversions
#![allow(clippy::useless_conversion)]

#[allow(unused_imports)]
use alloc::borrow::Cow;
#[allow(unused_imports)]
use core::convert::TryInto;
use alloc::vec;
use alloc::vec::Vec;
use core::convert::TryFrom;
use crate::errors::ParseError;
#[allow(unused_imports)]
use crate::x11_utils::TryIntoUSize;
use crate::BufWithFds;
#[allow(unused_imports)]
use crate::utils::{RawFdContainer, pretty_print_bitmask, pretty_print_enum};
#[allow(unused_imports)]
use crate::x11_utils::{Request, RequestHeader, Serialize, TryParse, TryParseFd};
#[allow(unused_imports)]
use super::xproto;

/// The X11 name of the extension for QueryExtension
pub const X11_EXTENSION_NAME: &str = "MIT-SHM";

/// The version number of this extension that this client library supports.
///
/// This constant contains the version number of this extension that is supported
/// by this build of x11rb. For most things, it does not make sense to use this
/// information. If you need to send a `QueryVersion`, it is recommended to instead
/// send the maximum version of the extension that you need.
pub const X11_XML_VERSION: (u32, u32) = (1, 2);

pub type Seg = u32;

/// Opcode for the Completion event
pub const COMPLETION_EVENT: u8 = 0;
/// Report that an XCB_SHM_PUT_IMAGE request has completed.
///
/// This is generated by the X server to report that an XCB_SHM_PUT_IMAGE request
/// has been successfully processed.
///
/// # Fields
///
/// * `drawable` - The drawable used in the XCB_SHM_PUT_IMAGE request.
/// * `minor_event` - The minor opcode used in the request.  Always XCB_SHM_PUT_IMAGE.
/// * `major_event` - The major opcode used in the request.  Always the opcode of the MIT-SHM
///   extension.
/// * `shmseg` - The shared memory segment used in the request.
/// * `offset` - The offset in the shared memory segment used in the request.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CompletionEvent {
    pub response_type: u8,
    pub sequence: u16,
    pub drawable: xproto::Drawable,
    pub minor_event: u16,
    pub major_event: u8,
    pub shmseg: Seg,
    pub offset: u32,
}
impl_debug_if_no_extra_traits!(CompletionEvent, "CompletionEvent");
impl TryParse for CompletionEvent {
    fn try_parse(initial_value: &[u8]) -> Result<(Self, &[u8]), ParseError> {
        let remaining = initial_value;
        let (response_type, remaining) = u8::try_parse(remaining)?;
        let remaining = remaining.get(1..).ok_or(ParseError::InsufficientData)?;
        let (sequence, remaining) = u16::try_parse(remaining)?;
        let (drawable, remaining) = xproto::Drawable::try_parse(remaining)?;
        let (minor_event, remaining) = u16::try_parse(remaining)?;
        let (major_event, remaining) = u8::try_parse(remaining)?;
        let remaining = remaining.get(1..).ok_or(ParseError::InsufficientData)?;
        let (shmseg, remaining) = Seg::try_parse(remaining)?;
        let (offset, remaining) = u32::try_parse(remaining)?;
        let result = CompletionEvent { response_type, sequence, drawable, minor_event, major_event, shmseg, offset };
        let _ = remaining;
        let remaining = initial_value.get(32..)
            .ok_or(ParseError::InsufficientData)?;
        Ok((result, remaining))
    }
}
impl Serialize for CompletionEvent {
    type Bytes = [u8; 20];
    fn serialize(&self) -> [u8; 20] {
        let response_type_bytes = self.response_type.serialize();
        let sequence_bytes = self.sequence.serialize();
        let drawable_bytes = self.drawable.serialize();
        let minor_event_bytes = self.minor_event.serialize();
        let major_event_bytes = self.major_event.serialize();
        let shmseg_bytes = self.shmseg.serialize();
        let offset_bytes = self.offset.serialize();
        [
            response_type_bytes[0],
            0,
            sequence_bytes[0],
            sequence_bytes[1],
            drawable_bytes[0],
            drawable_bytes[1],
            drawable_bytes[2],
            drawable_bytes[3],
            minor_event_bytes[0],
            minor_event_bytes[1],
            major_event_bytes[0],
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            offset_bytes[0],
            offset_bytes[1],
            offset_bytes[2],
            offset_bytes[3],
        ]
    }
    fn serialize_into(&self, bytes: &mut Vec<u8>) {
        bytes.reserve(20);
        self.response_type.serialize_into(bytes);
        bytes.extend_from_slice(&[0; 1]);
        self.sequence.serialize_into(bytes);
        self.drawable.serialize_into(bytes);
        self.minor_event.serialize_into(bytes);
        self.major_event.serialize_into(bytes);
        bytes.extend_from_slice(&[0; 1]);
        self.shmseg.serialize_into(bytes);
        self.offset.serialize_into(bytes);
    }
}
impl From<&CompletionEvent> for [u8; 32] {
    fn from(input: &CompletionEvent) -> Self {
        let response_type_bytes = input.response_type.serialize();
        let sequence_bytes = input.sequence.serialize();
        let drawable_bytes = input.drawable.serialize();
        let minor_event_bytes = input.minor_event.serialize();
        let major_event_bytes = input.major_event.serialize();
        let shmseg_bytes = input.shmseg.serialize();
        let offset_bytes = input.offset.serialize();
        [
            response_type_bytes[0],
            0,
            sequence_bytes[0],
            sequence_bytes[1],
            drawable_bytes[0],
            drawable_bytes[1],
            drawable_bytes[2],
            drawable_bytes[3],
            minor_event_bytes[0],
            minor_event_bytes[1],
            major_event_bytes[0],
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            offset_bytes[0],
            offset_bytes[1],
            offset_bytes[2],
            offset_bytes[3],
            // trailing padding
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    }
}
impl From<CompletionEvent> for [u8; 32] {
    fn from(input: CompletionEvent) -> Self {
        Self::from(&input)
    }
}

/// Opcode for the BadSeg error
pub const BAD_SEG_ERROR: u8 = 0;

/// Opcode for the QueryVersion request
pub const QUERY_VERSION_REQUEST: u8 = 0;
/// Query the version of the MIT-SHM extension..
///
/// This is used to determine the version of the MIT-SHM extension supported by the
/// X server.  Clients MUST NOT make other requests in this extension until a reply
/// to this requests indicates the X server supports them.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct QueryVersionRequest;
impl_debug_if_no_extra_traits!(QueryVersionRequest, "QueryVersionRequest");
impl QueryVersionRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let mut request0 = vec![
            major_opcode,
            QUERY_VERSION_REQUEST,
            0,
            0,
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != QUERY_VERSION_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let _ = value;
        Ok(QueryVersionRequest
        )
    }
}
impl Request for QueryVersionRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::ReplyRequest for QueryVersionRequest {
    type Reply = QueryVersionReply;
}

/// The version of the MIT-SHM extension supported by the server.
///
/// This contains the version of the MIT-SHM extension supported by the server, as
/// well as the server’s UID and GID.  Clients MUST obtain the version supproted by
/// the server before making other requests from this extension.  To prevent local
/// privilege escalation and local information leak security vulnerabilities,
/// clients MUST ensure that System V shared memory objects they use with this
/// extension can only be accessed by the client and the X server.  If this is not
/// possible, the requests in this extension that use System V shared memory MUST
/// NOT be used.  The file descriptor-passing versions provide an alternative.
///
/// # Fields
///
/// * `shared_pixmaps` - True if the server supports shared pixmaps, otherwise false.
/// * `major_version` - The major version of the extension supported.
/// * `minor_version` - The minor version of the extension supported.
/// * `uid` - The UID of the server.
/// * `gid` - The GID of the server.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct QueryVersionReply {
    pub shared_pixmaps: bool,
    pub sequence: u16,
    pub length: u32,
    pub major_version: u16,
    pub minor_version: u16,
    pub uid: u16,
    pub gid: u16,
    pub pixmap_format: u8,
}
impl_debug_if_no_extra_traits!(QueryVersionReply, "QueryVersionReply");
impl TryParse for QueryVersionReply {
    fn try_parse(initial_value: &[u8]) -> Result<(Self, &[u8]), ParseError> {
        let remaining = initial_value;
        let (response_type, remaining) = u8::try_parse(remaining)?;
        let (shared_pixmaps, remaining) = bool::try_parse(remaining)?;
        let (sequence, remaining) = u16::try_parse(remaining)?;
        let (length, remaining) = u32::try_parse(remaining)?;
        let (major_version, remaining) = u16::try_parse(remaining)?;
        let (minor_version, remaining) = u16::try_parse(remaining)?;
        let (uid, remaining) = u16::try_parse(remaining)?;
        let (gid, remaining) = u16::try_parse(remaining)?;
        let (pixmap_format, remaining) = u8::try_parse(remaining)?;
        let remaining = remaining.get(15..).ok_or(ParseError::InsufficientData)?;
        if response_type != 1 {
            return Err(ParseError::InvalidValue);
        }
        let result = QueryVersionReply { shared_pixmaps, sequence, length, major_version, minor_version, uid, gid, pixmap_format };
        let _ = remaining;
        let remaining = initial_value.get(32 + length as usize * 4..)
            .ok_or(ParseError::InsufficientData)?;
        Ok((result, remaining))
    }
}
impl Serialize for QueryVersionReply {
    type Bytes = [u8; 32];
    fn serialize(&self) -> [u8; 32] {
        let response_type_bytes = &[1];
        let shared_pixmaps_bytes = self.shared_pixmaps.serialize();
        let sequence_bytes = self.sequence.serialize();
        let length_bytes = self.length.serialize();
        let major_version_bytes = self.major_version.serialize();
        let minor_version_bytes = self.minor_version.serialize();
        let uid_bytes = self.uid.serialize();
        let gid_bytes = self.gid.serialize();
        let pixmap_format_bytes = self.pixmap_format.serialize();
        [
            response_type_bytes[0],
            shared_pixmaps_bytes[0],
            sequence_bytes[0],
            sequence_bytes[1],
            length_bytes[0],
            length_bytes[1],
            length_bytes[2],
            length_bytes[3],
            major_version_bytes[0],
            major_version_bytes[1],
            minor_version_bytes[0],
            minor_version_bytes[1],
            uid_bytes[0],
            uid_bytes[1],
            gid_bytes[0],
            gid_bytes[1],
            pixmap_format_bytes[0],
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    }
    fn serialize_into(&self, bytes: &mut Vec<u8>) {
        bytes.reserve(32);
        let response_type_bytes = &[1];
        bytes.push(response_type_bytes[0]);
        self.shared_pixmaps.serialize_into(bytes);
        self.sequence.serialize_into(bytes);
        self.length.serialize_into(bytes);
        self.major_version.serialize_into(bytes);
        self.minor_version.serialize_into(bytes);
        self.uid.serialize_into(bytes);
        self.gid.serialize_into(bytes);
        self.pixmap_format.serialize_into(bytes);
        bytes.extend_from_slice(&[0; 15]);
    }
}

/// Opcode for the Attach request
pub const ATTACH_REQUEST: u8 = 1;
/// Attach a System V shared memory segment..
///
/// Attach a System V shared memory segment to the server.  This will fail unless
/// the server has permission to map the segment.  The client may destroy the segment
/// as soon as it receives a XCB_SHM_COMPLETION event with the shmseg value in this
/// request and with the appropriate serial number.
///
/// # Fields
///
/// * `shmseg` - A shared memory segment ID created with xcb_generate_id().
/// * `shmid` - The System V shared memory segment the server should map.
/// * `read_only` - True if the segment shall be mapped read only by the X11 server, otherwise false.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct AttachRequest {
    pub shmseg: Seg,
    pub shmid: u32,
    pub read_only: bool,
}
impl_debug_if_no_extra_traits!(AttachRequest, "AttachRequest");
impl AttachRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let shmseg_bytes = self.shmseg.serialize();
        let shmid_bytes = self.shmid.serialize();
        let read_only_bytes = self.read_only.serialize();
        let mut request0 = vec![
            major_opcode,
            ATTACH_REQUEST,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            shmid_bytes[0],
            shmid_bytes[1],
            shmid_bytes[2],
            shmid_bytes[3],
            read_only_bytes[0],
            0,
            0,
            0,
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != ATTACH_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (shmseg, remaining) = Seg::try_parse(value)?;
        let (shmid, remaining) = u32::try_parse(remaining)?;
        let (read_only, remaining) = bool::try_parse(remaining)?;
        let remaining = remaining.get(3..).ok_or(ParseError::InsufficientData)?;
        let _ = remaining;
        Ok(AttachRequest {
            shmseg,
            shmid,
            read_only,
        })
    }
}
impl Request for AttachRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::VoidRequest for AttachRequest {
}

/// Opcode for the Detach request
pub const DETACH_REQUEST: u8 = 2;
/// Destroys the specified shared memory segment..
///
/// Destroys the specified shared memory segment.  This will never fail unless the
/// segment number is incorrect.
///
/// # Fields
///
/// * `shmseg` - The segment to be destroyed.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct DetachRequest {
    pub shmseg: Seg,
}
impl_debug_if_no_extra_traits!(DetachRequest, "DetachRequest");
impl DetachRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let shmseg_bytes = self.shmseg.serialize();
        let mut request0 = vec![
            major_opcode,
            DETACH_REQUEST,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != DETACH_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (shmseg, remaining) = Seg::try_parse(value)?;
        let _ = remaining;
        Ok(DetachRequest {
            shmseg,
        })
    }
}
impl Request for DetachRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::VoidRequest for DetachRequest {
}

/// Opcode for the PutImage request
pub const PUT_IMAGE_REQUEST: u8 = 3;
/// Copy data from the shared memory to the specified drawable..
///
/// Copy data from the shared memory to the specified drawable.  The amount of bytes
/// written to the destination image is always equal to the number of bytes read
/// from the shared memory segment.
///
/// # Fields
///
/// * `drawable` - The drawable to draw to.
/// * `gc` - The graphics context to use.
/// * `total_width` - The total width of the source image.
/// * `total_height` - The total height of the source image.
/// * `src_x` - The source X coordinate of the sub-image to copy.
/// * `src_y` - The source Y coordinate of the sub-image to copy.
/// * `src_width` - The width, in source image coordinates, of the data to copy from the source.
///   The X server will use this to determine the amount of data to copy.  The amount
///   of the destination image that is overwritten is determined automatically.
/// * `src_height` - The height, in source image coordinates, of the data to copy from the source.
///   The X server will use this to determine the amount of data to copy.  The amount
///   of the destination image that is overwritten is determined automatically.
/// * `dst_x` - The X coordinate on the destination drawable to copy to.
/// * `dst_y` - The Y coordinate on the destination drawable to copy to.
/// * `depth` - The depth to use.
/// * `format` - The format of the image being drawn.  If it is XYBitmap, depth must be 1, or a
///   "BadMatch" error results.  The foreground pixel in the GC determines the source
///   for the one bits in the image, and the background pixel determines the source
///   for the zero bits.  For XYPixmap and ZPixmap, the depth must match the depth of
///   the drawable, or a "BadMatch" error results.
/// * `send_event` - True if the server should send an XCB_SHM_COMPLETION event when the blit
///   completes.
/// * `offset` - The offset that the source image starts at.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct PutImageRequest {
    pub drawable: xproto::Drawable,
    pub gc: xproto::Gcontext,
    pub total_width: u16,
    pub total_height: u16,
    pub src_x: u16,
    pub src_y: u16,
    pub src_width: u16,
    pub src_height: u16,
    pub dst_x: i16,
    pub dst_y: i16,
    pub depth: u8,
    pub format: u8,
    pub send_event: bool,
    pub shmseg: Seg,
    pub offset: u32,
}
impl_debug_if_no_extra_traits!(PutImageRequest, "PutImageRequest");
impl PutImageRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let drawable_bytes = self.drawable.serialize();
        let gc_bytes = self.gc.serialize();
        let total_width_bytes = self.total_width.serialize();
        let total_height_bytes = self.total_height.serialize();
        let src_x_bytes = self.src_x.serialize();
        let src_y_bytes = self.src_y.serialize();
        let src_width_bytes = self.src_width.serialize();
        let src_height_bytes = self.src_height.serialize();
        let dst_x_bytes = self.dst_x.serialize();
        let dst_y_bytes = self.dst_y.serialize();
        let depth_bytes = self.depth.serialize();
        let format_bytes = self.format.serialize();
        let send_event_bytes = self.send_event.serialize();
        let shmseg_bytes = self.shmseg.serialize();
        let offset_bytes = self.offset.serialize();
        let mut request0 = vec![
            major_opcode,
            PUT_IMAGE_REQUEST,
            0,
            0,
            drawable_bytes[0],
            drawable_bytes[1],
            drawable_bytes[2],
            drawable_bytes[3],
            gc_bytes[0],
            gc_bytes[1],
            gc_bytes[2],
            gc_bytes[3],
            total_width_bytes[0],
            total_width_bytes[1],
            total_height_bytes[0],
            total_height_bytes[1],
            src_x_bytes[0],
            src_x_bytes[1],
            src_y_bytes[0],
            src_y_bytes[1],
            src_width_bytes[0],
            src_width_bytes[1],
            src_height_bytes[0],
            src_height_bytes[1],
            dst_x_bytes[0],
            dst_x_bytes[1],
            dst_y_bytes[0],
            dst_y_bytes[1],
            depth_bytes[0],
            format_bytes[0],
            send_event_bytes[0],
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            offset_bytes[0],
            offset_bytes[1],
            offset_bytes[2],
            offset_bytes[3],
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != PUT_IMAGE_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (drawable, remaining) = xproto::Drawable::try_parse(value)?;
        let (gc, remaining) = xproto::Gcontext::try_parse(remaining)?;
        let (total_width, remaining) = u16::try_parse(remaining)?;
        let (total_height, remaining) = u16::try_parse(remaining)?;
        let (src_x, remaining) = u16::try_parse(remaining)?;
        let (src_y, remaining) = u16::try_parse(remaining)?;
        let (src_width, remaining) = u16::try_parse(remaining)?;
        let (src_height, remaining) = u16::try_parse(remaining)?;
        let (dst_x, remaining) = i16::try_parse(remaining)?;
        let (dst_y, remaining) = i16::try_parse(remaining)?;
        let (depth, remaining) = u8::try_parse(remaining)?;
        let (format, remaining) = u8::try_parse(remaining)?;
        let (send_event, remaining) = bool::try_parse(remaining)?;
        let remaining = remaining.get(1..).ok_or(ParseError::InsufficientData)?;
        let (shmseg, remaining) = Seg::try_parse(remaining)?;
        let (offset, remaining) = u32::try_parse(remaining)?;
        let _ = remaining;
        Ok(PutImageRequest {
            drawable,
            gc,
            total_width,
            total_height,
            src_x,
            src_y,
            src_width,
            src_height,
            dst_x,
            dst_y,
            depth,
            format,
            send_event,
            shmseg,
            offset,
        })
    }
}
impl Request for PutImageRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::VoidRequest for PutImageRequest {
}

/// Opcode for the GetImage request
pub const GET_IMAGE_REQUEST: u8 = 4;
/// Copies data from the specified drawable to the shared memory segment..
///
/// Copy data from the specified drawable to the shared memory segment.  The amount
/// of bytes written to the destination image is always equal to the number of bytes
/// read from the shared memory segment.
///
/// # Fields
///
/// * `drawable` - The drawable to copy the image out of.
/// * `x` - The X coordinate in the drawable to begin copying at.
/// * `y` - The Y coordinate in the drawable to begin copying at.
/// * `width` - The width of the image to copy.
/// * `height` - The height of the image to copy.
/// * `plane_mask` - A mask that determines which planes are used.
/// * `format` - The format to use for the copy (???).
/// * `shmseg` - The destination shared memory segment.
/// * `offset` - The offset in the shared memory segment to copy data to.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct GetImageRequest {
    pub drawable: xproto::Drawable,
    pub x: i16,
    pub y: i16,
    pub width: u16,
    pub height: u16,
    pub plane_mask: u32,
    pub format: u8,
    pub shmseg: Seg,
    pub offset: u32,
}
impl_debug_if_no_extra_traits!(GetImageRequest, "GetImageRequest");
impl GetImageRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let drawable_bytes = self.drawable.serialize();
        let x_bytes = self.x.serialize();
        let y_bytes = self.y.serialize();
        let width_bytes = self.width.serialize();
        let height_bytes = self.height.serialize();
        let plane_mask_bytes = self.plane_mask.serialize();
        let format_bytes = self.format.serialize();
        let shmseg_bytes = self.shmseg.serialize();
        let offset_bytes = self.offset.serialize();
        let mut request0 = vec![
            major_opcode,
            GET_IMAGE_REQUEST,
            0,
            0,
            drawable_bytes[0],
            drawable_bytes[1],
            drawable_bytes[2],
            drawable_bytes[3],
            x_bytes[0],
            x_bytes[1],
            y_bytes[0],
            y_bytes[1],
            width_bytes[0],
            width_bytes[1],
            height_bytes[0],
            height_bytes[1],
            plane_mask_bytes[0],
            plane_mask_bytes[1],
            plane_mask_bytes[2],
            plane_mask_bytes[3],
            format_bytes[0],
            0,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            offset_bytes[0],
            offset_bytes[1],
            offset_bytes[2],
            offset_bytes[3],
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != GET_IMAGE_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (drawable, remaining) = xproto::Drawable::try_parse(value)?;
        let (x, remaining) = i16::try_parse(remaining)?;
        let (y, remaining) = i16::try_parse(remaining)?;
        let (width, remaining) = u16::try_parse(remaining)?;
        let (height, remaining) = u16::try_parse(remaining)?;
        let (plane_mask, remaining) = u32::try_parse(remaining)?;
        let (format, remaining) = u8::try_parse(remaining)?;
        let remaining = remaining.get(3..).ok_or(ParseError::InsufficientData)?;
        let (shmseg, remaining) = Seg::try_parse(remaining)?;
        let (offset, remaining) = u32::try_parse(remaining)?;
        let _ = remaining;
        Ok(GetImageRequest {
            drawable,
            x,
            y,
            width,
            height,
            plane_mask,
            format,
            shmseg,
            offset,
        })
    }
}
impl Request for GetImageRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::ReplyRequest for GetImageRequest {
    type Reply = GetImageReply;
}

/// Indicates the result of the copy..
///
/// The result of the copy.
///
/// # Fields
///
/// * `depth` - The depth of the source drawable.
/// * `visual` - The visual ID of the source drawable.
/// * `size` - The number of bytes copied.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct GetImageReply {
    pub depth: u8,
    pub sequence: u16,
    pub length: u32,
    pub visual: xproto::Visualid,
    pub size: u32,
}
impl_debug_if_no_extra_traits!(GetImageReply, "GetImageReply");
impl TryParse for GetImageReply {
    fn try_parse(initial_value: &[u8]) -> Result<(Self, &[u8]), ParseError> {
        let remaining = initial_value;
        let (response_type, remaining) = u8::try_parse(remaining)?;
        let (depth, remaining) = u8::try_parse(remaining)?;
        let (sequence, remaining) = u16::try_parse(remaining)?;
        let (length, remaining) = u32::try_parse(remaining)?;
        let (visual, remaining) = xproto::Visualid::try_parse(remaining)?;
        let (size, remaining) = u32::try_parse(remaining)?;
        if response_type != 1 {
            return Err(ParseError::InvalidValue);
        }
        let result = GetImageReply { depth, sequence, length, visual, size };
        let _ = remaining;
        let remaining = initial_value.get(32 + length as usize * 4..)
            .ok_or(ParseError::InsufficientData)?;
        Ok((result, remaining))
    }
}
impl Serialize for GetImageReply {
    type Bytes = [u8; 16];
    fn serialize(&self) -> [u8; 16] {
        let response_type_bytes = &[1];
        let depth_bytes = self.depth.serialize();
        let sequence_bytes = self.sequence.serialize();
        let length_bytes = self.length.serialize();
        let visual_bytes = self.visual.serialize();
        let size_bytes = self.size.serialize();
        [
            response_type_bytes[0],
            depth_bytes[0],
            sequence_bytes[0],
            sequence_bytes[1],
            length_bytes[0],
            length_bytes[1],
            length_bytes[2],
            length_bytes[3],
            visual_bytes[0],
            visual_bytes[1],
            visual_bytes[2],
            visual_bytes[3],
            size_bytes[0],
            size_bytes[1],
            size_bytes[2],
            size_bytes[3],
        ]
    }
    fn serialize_into(&self, bytes: &mut Vec<u8>) {
        bytes.reserve(16);
        let response_type_bytes = &[1];
        bytes.push(response_type_bytes[0]);
        self.depth.serialize_into(bytes);
        self.sequence.serialize_into(bytes);
        self.length.serialize_into(bytes);
        self.visual.serialize_into(bytes);
        self.size.serialize_into(bytes);
    }
}

/// Opcode for the CreatePixmap request
pub const CREATE_PIXMAP_REQUEST: u8 = 5;
/// Create a pixmap backed by shared memory..
///
/// Create a pixmap backed by shared memory.  Writes to the shared memory will be
/// reflected in the contents of the pixmap, and writes to the pixmap will be
/// reflected in the contents of the shared memory.
///
/// # Fields
///
/// * `pid` - A pixmap ID created with xcb_generate_id().
/// * `drawable` - The drawable to create the pixmap in.
/// * `width` - The width of the pixmap to create.  Must be nonzero, or a Value error results.
/// * `height` - The height of the pixmap to create.  Must be nonzero, or a Value error results.
/// * `depth` - The depth of the pixmap to create.  Must be nonzero, or a Value error results.
/// * `shmseg` - The shared memory segment to use to create the pixmap.
/// * `offset` - The offset in the segment to create the pixmap at.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CreatePixmapRequest {
    pub pid: xproto::Pixmap,
    pub drawable: xproto::Drawable,
    pub width: u16,
    pub height: u16,
    pub depth: u8,
    pub shmseg: Seg,
    pub offset: u32,
}
impl_debug_if_no_extra_traits!(CreatePixmapRequest, "CreatePixmapRequest");
impl CreatePixmapRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let pid_bytes = self.pid.serialize();
        let drawable_bytes = self.drawable.serialize();
        let width_bytes = self.width.serialize();
        let height_bytes = self.height.serialize();
        let depth_bytes = self.depth.serialize();
        let shmseg_bytes = self.shmseg.serialize();
        let offset_bytes = self.offset.serialize();
        let mut request0 = vec![
            major_opcode,
            CREATE_PIXMAP_REQUEST,
            0,
            0,
            pid_bytes[0],
            pid_bytes[1],
            pid_bytes[2],
            pid_bytes[3],
            drawable_bytes[0],
            drawable_bytes[1],
            drawable_bytes[2],
            drawable_bytes[3],
            width_bytes[0],
            width_bytes[1],
            height_bytes[0],
            height_bytes[1],
            depth_bytes[0],
            0,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            offset_bytes[0],
            offset_bytes[1],
            offset_bytes[2],
            offset_bytes[3],
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != CREATE_PIXMAP_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (pid, remaining) = xproto::Pixmap::try_parse(value)?;
        let (drawable, remaining) = xproto::Drawable::try_parse(remaining)?;
        let (width, remaining) = u16::try_parse(remaining)?;
        let (height, remaining) = u16::try_parse(remaining)?;
        let (depth, remaining) = u8::try_parse(remaining)?;
        let remaining = remaining.get(3..).ok_or(ParseError::InsufficientData)?;
        let (shmseg, remaining) = Seg::try_parse(remaining)?;
        let (offset, remaining) = u32::try_parse(remaining)?;
        let _ = remaining;
        Ok(CreatePixmapRequest {
            pid,
            drawable,
            width,
            height,
            depth,
            shmseg,
            offset,
        })
    }
}
impl Request for CreatePixmapRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::VoidRequest for CreatePixmapRequest {
}

/// Opcode for the AttachFd request
pub const ATTACH_FD_REQUEST: u8 = 6;
/// Create a shared memory segment.
///
/// Create a shared memory segment.  The file descriptor will be mapped at offset
/// zero, and the size will be obtained using fstat().  A zero size will result in a
/// Value error.
///
/// # Fields
///
/// * `shmseg` - A shared memory segment ID created with xcb_generate_id().
/// * `shm_fd` - The file descriptor the server should mmap().
/// * `read_only` - True if the segment shall be mapped read only by the X11 server, otherwise false.
#[cfg_attr(feature = "extra-traits", derive(Debug))]
pub struct AttachFdRequest {
    pub shmseg: Seg,
    pub shm_fd: RawFdContainer,
    pub read_only: bool,
}
impl_debug_if_no_extra_traits!(AttachFdRequest, "AttachFdRequest");
impl AttachFdRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let shmseg_bytes = self.shmseg.serialize();
        let read_only_bytes = self.read_only.serialize();
        let mut request0 = vec![
            major_opcode,
            ATTACH_FD_REQUEST,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            read_only_bytes[0],
            0,
            0,
            0,
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![self.shm_fd])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request_fd(header: RequestHeader, value: &[u8], fds: &mut Vec<RawFdContainer>) -> Result<Self, ParseError> {
        if header.minor_opcode != ATTACH_FD_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (shmseg, remaining) = Seg::try_parse(value)?;
        if fds.is_empty() { return Err(ParseError::MissingFileDescriptors) }
        let shm_fd = fds.remove(0);
        let (read_only, remaining) = bool::try_parse(remaining)?;
        let remaining = remaining.get(3..).ok_or(ParseError::InsufficientData)?;
        let _ = remaining;
        Ok(AttachFdRequest {
            shmseg,
            shm_fd,
            read_only,
        })
    }
}
impl Request for AttachFdRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::VoidRequest for AttachFdRequest {
}

/// Opcode for the CreateSegment request
pub const CREATE_SEGMENT_REQUEST: u8 = 7;
/// Asks the server to allocate a shared memory segment..
///
/// Asks the server to allocate a shared memory segment.  The server’s reply will
/// include a file descriptor for the client to pass to mmap().
///
/// # Fields
///
/// * `shmseg` - A shared memory segment ID created with xcb_generate_id().
/// * `size` - The size of the segment to create.
/// * `read_only` - True if the server should map the segment read-only; otherwise false.
#[derive(Clone, Copy, Default)]
#[cfg_attr(feature = "extra-traits", derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash))]
#[cfg_attr(feature = "serde", derive(serde::Serialize, serde::Deserialize))]
pub struct CreateSegmentRequest {
    pub shmseg: Seg,
    pub size: u32,
    pub read_only: bool,
}
impl_debug_if_no_extra_traits!(CreateSegmentRequest, "CreateSegmentRequest");
impl CreateSegmentRequest {
    /// Serialize this request into bytes for the provided connection
    pub fn serialize(self, major_opcode: u8) -> BufWithFds<[Cow<'static, [u8]>; 1]> {
        let length_so_far = 0;
        let shmseg_bytes = self.shmseg.serialize();
        let size_bytes = self.size.serialize();
        let read_only_bytes = self.read_only.serialize();
        let mut request0 = vec![
            major_opcode,
            CREATE_SEGMENT_REQUEST,
            0,
            0,
            shmseg_bytes[0],
            shmseg_bytes[1],
            shmseg_bytes[2],
            shmseg_bytes[3],
            size_bytes[0],
            size_bytes[1],
            size_bytes[2],
            size_bytes[3],
            read_only_bytes[0],
            0,
            0,
            0,
        ];
        let length_so_far = length_so_far + request0.len();
        assert_eq!(length_so_far % 4, 0);
        let length = u16::try_from(length_so_far / 4).unwrap_or(0);
        request0[2..4].copy_from_slice(&length.to_ne_bytes());
        ([request0.into()], vec![])
    }
    /// Parse this request given its header, its body, and any fds that go along with it
    #[cfg(feature = "request-parsing")]
    pub fn try_parse_request(header: RequestHeader, value: &[u8]) -> Result<Self, ParseError> {
        if header.minor_opcode != CREATE_SEGMENT_REQUEST {
            return Err(ParseError::InvalidValue);
        }
        let (shmseg, remaining) = Seg::try_parse(value)?;
        let (size, remaining) = u32::try_parse(remaining)?;
        let (read_only, remaining) = bool::try_parse(remaining)?;
        let remaining = remaining.get(3..).ok_or(ParseError::InsufficientData)?;
        let _ = remaining;
        Ok(CreateSegmentRequest {
            shmseg,
            size,
            read_only,
        })
    }
}
impl Request for CreateSegmentRequest {
    const EXTENSION_NAME: Option<&'static str> = Some(X11_EXTENSION_NAME);

    fn serialize(self, major_opcode: u8) -> BufWithFds<Vec<u8>> {
        let (bufs, fds) = self.serialize(major_opcode);
        // Flatten the buffers into a single vector
        let buf = bufs.iter().flat_map(|buf| buf.iter().copied()).collect();
        (buf, fds)
    }
}
impl crate::x11_utils::ReplyFDsRequest for CreateSegmentRequest {
    type Reply = CreateSegmentReply;
}

/// The returned file descriptor..
///
/// The file descriptor returned by the server.  The client may call mmap() on it to
/// map the memory allocated by the server.
///
/// # Fields
///
/// * `nfd` - The number of file descriptors sent by the server.  Will always be 1.
#[cfg_attr(feature = "extra-traits", derive(Debug))]
pub struct CreateSegmentReply {
    pub nfd: u8,
    pub sequence: u16,
    pub length: u32,
    pub shm_fd: RawFdContainer,
}
impl_debug_if_no_extra_traits!(CreateSegmentReply, "CreateSegmentReply");
impl TryParseFd for CreateSegmentReply {
    fn try_parse_fd<'a>(initial_value: &'a [u8], fds: &mut Vec<RawFdContainer>) -> Result<(Self, &'a [u8]), ParseError> {
        let remaining = initial_value;
        let (response_type, remaining) = u8::try_parse(remaining)?;
        let (nfd, remaining) = u8::try_parse(remaining)?;
        let (sequence, remaining) = u16::try_parse(remaining)?;
        let (length, remaining) = u32::try_parse(remaining)?;
        if fds.is_empty() { return Err(ParseError::MissingFileDescriptors) }
        let shm_fd = fds.remove(0);
        let remaining = remaining.get(24..).ok_or(ParseError::InsufficientData)?;
        if response_type != 1 {
            return Err(ParseError::InvalidValue);
        }
        let result = CreateSegmentReply { nfd, sequence, length, shm_fd };
        let _ = remaining;
        let remaining = initial_value.get(32 + length as usize * 4..)
            .ok_or(ParseError::InsufficientData)?;
        Ok((result, remaining))
    }
}
impl Serialize for CreateSegmentReply {
    type Bytes = [u8; 32];
    fn serialize(&self) -> [u8; 32] {
        let response_type_bytes = &[1];
        let nfd_bytes = self.nfd.serialize();
        let sequence_bytes = self.sequence.serialize();
        let length_bytes = self.length.serialize();
        [
            response_type_bytes[0],
            nfd_bytes[0],
            sequence_bytes[0],
            sequence_bytes[1],
            length_bytes[0],
            length_bytes[1],
            length_bytes[2],
            length_bytes[3],
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    }
    fn serialize_into(&self, bytes: &mut Vec<u8>) {
        bytes.reserve(32);
        let response_type_bytes = &[1];
        bytes.push(response_type_bytes[0]);
        self.nfd.serialize_into(bytes);
        self.sequence.serialize_into(bytes);
        self.length.serialize_into(bytes);
        bytes.extend_from_slice(&[0; 24]);
    }
}

