/* $XTermId: wcwidth.h,v 1.18 2025/11/27 15:19:41 tom Exp $ */

/* $XFree86: xc/programs/xterm/wcwidth.h,v 1.5 2005/05/03 00:38:25 dickey Exp $ */

/*
 * Copyright 2000-2017,2025 by Thomas E. Dickey
 *
 *                         All Rights Reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name(s) of the above copyright
 * holders shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization.
 */
#ifndef	included_wcwidth_h
#define	included_wcwidth_h 1

#include <stddef.h>

typedef enum {
    WcUnknown = 0
    ,WcSoftHyphen = 1		/* soft-hyphen is spacing, e.g., Latin-1 */
    ,WcPrivateFullwidth = 2	/* private-use codes can be fullwidth in CJK */
    ,WcEmojiFullwidth = 4	/* Emojis are fullwidth */
} WcModes;

extern int mk_wcwidth_init(int mode);

#define XTermWcInit(utf8) \
	mk_wcwidth_init(((utf8) ? WcSoftHyphen : WcUnknown) \
			 | WcPrivateFullwidth \
			 | WcEmojiFullwidth)

extern int mk_wcwidth(wchar_t ucs);
extern int mk_wcwidth_cjk(wchar_t ucs);

extern int mk_is_emoji(wchar_t ucs);

#endif /* included_wcwidth_h */
