# User Guide

Welcome to the user guide, where you can learn more about using Zarr-Python!

## Getting Started

New to Zarr-Python? Start here:

- **[Installation](installation.md)** - Install Zarr-Python
- **[Quick-start](../quick-start.md)** - Quick overview of core functionality

## Core Concepts

Learn the essential building blocks:

- **[Arrays](arrays.md)** - Learn the fundamentals of working with arrays
- **[Groups](groups.md)** - Organize your data with groups
- **[Attributes](attributes.md)** - Configure metadata to your data structures
- **[Storage](storage.md)** - Learn how data is stored and accessed

## Configuration & Setup

Customize your experience:

- **[Runtime Configuration](config.md)** - Configure Zarr-Python for your needs
- **[V3 Migration](v3_migration.md)** - Upgrading from version 2 to version 3

## Advanced Topics

Take your skills to the next level:

- **[Data Types](data_types.md)** - Learn about supported and extensible data types
- **[Performance](performance.md)** - Optimize for speed and efficiency
- **[GPU](gpu.md)** - Leverage GPU acceleration
- **[Extending](extending.md)** - Extend functionality with custom code
- **[Consolidated Metadata](consolidated_metadata.md)** - Advanced metadata management

## Need Help?

- Browse the [API Reference](../api/zarr/index.md) for detailed function documentation
- Report issues on [GitHub](https://github.com/zarr-developers/zarr-python/issues?q=sort%3Aupdated-desc+is%3Aissue+is%3Aopen)
